MODULE FComms_tools

!*******************************************************************
!	
!	MODULE contains tools for communicating with C++
!
!*******************************************************************

IMPLICIT none


CONTAINS

	
SUBROUTINE ExcelComms( OpenFileName, SheetName, SaveFileName, RowStart, ColStart, RowNumb, ColNumb, ReadFlag, SaveFlag, xx )

!*******************************************************************
!	
!	MODULE contains tools for communicating with C++
!
!*******************************************************************

use, intrinsic :: ISO_C_BINDING

IMPLICIT none

character(2000) :: OpenFileName, SaveFileName
character(256) :: SheetName
integer(4) :: RowStart, ColStart, RowNumb, ColNumb, ReadFlag, SaveFlag
real(8) :: xx(RowNumb,ColNumb)

! local variables
character(2000) :: OpenFileName1, SaveFileName1
character(256) :: SheetName1
integer(c_int) :: oFNLen, SNLen, SFNLen
integer(4) :: FileNameL, SheetNameL, int_vec(6)
integer(4) :: ii, jj


!*************************************************************
!	begin code
!*************************************************************

! C++ interfaces
INTERFACE

	SUBROUTINE CppExcelComms(OpenFileName_c, OpenFileName_len, SheetName_c, SheetName_len, SaveFileName_c, SaveFileName_len, int_vec_c, xx_c) bind(C, name="CppExcelComms")

		use, intrinsic :: ISO_C_BINDING
		integer(c_int) :: OpenFileName_len
		character(kind=c_char) :: OpenFileName_c(OpenFileName_len)
		integer(c_int) :: SheetName_len
		character(kind=c_char) :: SheetName_c(SheetName_len)
		integer(c_int) :: SaveFileName_len
		character(kind=c_char) :: SaveFileName_c(SaveFileName_len)
		integer(c_long) :: int_vec_c(6)
		real(c_double) :: xx_c(int_vec(3)*int_vec(4))
	END SUBROUTINE CppExcelComms
	
END INTERFACE

! run checks to ensure references can be managed
if ( RowStart.lt.1 ) then

	print *, "Attempt to reference Excel row index less than 1"
	pause "press enter to exit"
	stop
end if
if ( ColStart.lt.1 ) then

	print *, "Attempt to reference Excel column index less than 1"
	pause "press enter to exit"
	stop
end if
if ( (RowStart+RowNumb-1).gt.1000000 ) then

	print *, "Attempt to reference Excel row index greater than 1000000"
	pause "press enter to exit"
	stop
end if
if ( (ColStart+ColNumb-1).gt.16000 ) then

	print *, "Attempt to reference Excel column index greater than 16000"
	pause "press enter to exit"
	stop
end if
if ( RowNumb.lt.1 ) then

	print *, "Attempt to reference fewer than 1 Excel rows"
	pause "press enter to exit"
	stop
end if
if ( ColNumb.lt.1 ) then

	print *, "Attempt to reference feser than 1 Excel columns"
	pause "press enter to exit"
	stop
end if

! preliminary variables
int_vec(1) = RowStart	!index of first row to read from
int_vec(2) = ColStart	!index of first column to read from
int_vec(3) = RowNumb	!number of rows to read from
int_vec(4) = ColNumb	!number of columns to read from
int_vec(5) = ReadFlag	!flag=1 if read (otherwise write)
if ( ReadFlag.eq.1 ) then
	
	int_vec(6) = SaveFlag	!flag=1 if save
	xx = 0.0
else
	
	int_vec(6) = 1
end if

! call C++ wrapper
OpenFileName1 = trim(OpenFileName) // char(0)
SheetName1 = trim(SheetName) // char(0)
SaveFileName1 = trim(SaveFileName) // char(0)
OFNLen = Len(trim(OpenFileName1), kind=c_int)
SNLen = Len(trim(SheetName1), kind=c_int)
SFNLen = Len(trim(SaveFileName1), kind=c_int)
call CppExcelComms( trim(OpenFileName1), OFNLen, trim(SheetName1), SNLen, trim(SaveFileName1), SFNLen, int_vec, xx )
continue


END SUBROUTINE ExcelComms


END MODULE FComms_tools